ax   equ 0
ay   equ 0
az   equ 0

 ld   a,ax
 ld   hl,angleX
 ld   [hli],a
 ld   a,ay
 ld   [hli],a
 ld   a,az
 ld   [hl],a
 call IniObjectScroll
 xor  a
 ld   [brezColor],a
 ld   a,1
 ld   [KeyDelay],a    
 ld   [VisibleSurfaces+$0f],a
 ld   a,1
 ld   [sdy],a
 ld   a,2
 ld   [sdx],a

 call IniObjectScroll
 call SetFont         ; move font to video RAM

 ld   hl,vmode
 set  7,[hl]
 ld   hl,vproc
 ld   [hl],1
 call ShapeIni
motLoop:
 call motion
 ld   a,[isMotion]
 or   a
 jr   z,motLoop
 ld   hl,wPal
 ld   l,[hl]
 xor  a
 ld   h,a
 add  hl,hl
 add  hl,hl
 add  hl,hl
 ld   bc,MyPal
 add  hl,bc
 ld   c,8
 ld   de,FreeMem          
 call CopyHLtoDEinC
 ld   c,8
 ld   hl,ObjPal
 call CopyHLtoDEinC
 ld   b,32
fadeEffect:
 push bc
 ld   b,1
 call haltbv
 xor  a             ;  a: index of pal
 ld   b,8           ;  b: how many colors /32 all
 ld   hl,FreeMem    ; hl: start of monoPalette /only one color-component
 push hl
 call SetBkgPalette
 xor  a
 ld   b,8
 call SetObjPalette
 pop  hl
 ld   b,8
 call ColorFading
 call motion
 pop  bc
 dec  b
 jr   nz,fadeEffect
 xor  a
 ld   [rSCX],a
 ld   [rSCY],a
 ld   [vproc],a
 ld   hl,vmode
 ld   [hl],$80
 ld   b,2
 call haltbv
 call ClearObjects
 call ClearScr1Map
 call ClearScrBank1
 call ClearScr2Map
 call ClearScrBank2
zx:
 jp   FinalMess
;
worldsMotion:
 ld   hl,$d480
 ld   de,$d4c0
 call wMotion
 ld   hl,$d440
 call wMotion
 ld   hl,$d400
 call wMotion
 ld   hl,$d0c0
 call wMotion
 ld   hl,$d080
 call wMotion
 ld   hl,$d040
 call wMotion
 ld   hl,$d000
 call wMotion
 ld   a,[wbuf]
 ld   h,a
 xor  a
 ld   l,a
 ld   b,4
wMotClear:
 rept 64
 ld   [hli],a
 endr
 ld   l,a
 inc  h
 dec  b
 jr   nz,wMotClear
 ret
wMotion:
 push hl
 ld   a,[wbuf]
 cp   $d0
 jr   z,@+6
 set  3,d
 set  3,h
 ld   b,4
wMotion1:
 push de
 push hl
 rept 64
 ld   a,[hli]
 ld   [de],a
 inc  e
 endr
 pop  hl
 pop  de
 inc  h
 inc  d
 dec  b
 jp   nz,wMotion1
 pop  de
 ret
InfWorldsBlank:
 push hl
 ld   hl,sdx
 ld   a,[hli]
 ld   h,[hl]
 ld   l,a
 ldio a,[$42]
 add  a,h
 ldio [$42],a
 ldio a,[$43]
 add  a,l
 ldio [$43],a
 pop  hl

 ld   a,[rLCDC]         ; Flip screens
 xor  $08
 ld   [rLCDC],a
 rrca
 rrca
 rrca
 and  1                 ; bg bank 9800 or 9c00
 xor  1
 ld   [rVBK],a          ; Set video bank for DMA  ; bank 0 or 1

 ld   a,[wbuf]
 ld   [rHDMA1],a        ; High Address value of source
 xor  sbuf0^sbuf1
 ld   [wbuf],a
 ld   a,$88
 ld   [rHDMA3],a        ; High Address value of destination
 xor  a
 ld   [rHDMA2],a        ; Low Address value of source
 ld   [rHDMA4],a        ; Low Address value of destination
 ld   [RenderingEnd],a

 ld   a,$ff             ; a= $ff  ; 128 lines DMA
 ld   [rHDMA5],a        ; 
 ld   [SecondPartDMA],a ; not zero    
 pop  af
 reti

motion:
 call MoveObjScroll

 ld   a,[vproc]
 cp   1
 jr   nz,moti1
 call worldsMotion
 jr   motiCont
moti1:

 ld   a,[wbuf]
 ld   h,a                                             
 xor  a                                               
 ld   l,a                                             
 call $d4b1
 call $d4b1
 call $d4b1

motiCont:
 ld   b,3
 ld   hl,angleX
; ld   h,b
 ld   a,[hl]
 add  a,b
 ld   [hli],a

 ld   a,[hl]
 add  a,b
 inc  a
 ld   [hli],a

 ld   a,[hl]
 add  a,b
 ld   [hl],a

noAuto:
 call RotateAroundXYZ   ; makes matrix of Rotations around 3 axes

 ld   a,[Surfaces]
 ld   l,a
 ld   a,[Surfaces+1]    ;  
 ld   h,a
 call Rotator
;
 ld   a,1               ; Report to vblank routine 
 ld   [RenderingEnd],a  ; about RenderingEnd

 ld   a,[RenderingEnd]  ; wait what vblank will start DMA
 or   a                 ; and switch wbuf
 jr   nz,@-3
;---------------------------------
 ld   hl,KeyDelay
 dec  [hl]
 jp   nz,noGetKeys
 ld   [hl],10           ; delay here
 call GetKeys
 ld   b,a
 ld   a,[isMotion]
 or   a
 ret  nz 
 bit  7,b
 jr   z,noStart
 xor  a
 ld   [sdx],a
 ld   [sdy],a
noStart:
 bit  6,b
 jr   z,noSel
 ld   hl,isMotion
 inc  [hl]
;
noSel
 bit  5,b
 jr   z,noB
 push bc
 ld   hl,wPal
 ld   a,[hl]
 inc  a
 and  7
 ld   [hl],a
 ld   l,a
 xor  a
 ld   h,a
 add  hl,hl
 add  hl,hl
 add  hl,hl
 ld   bc,MyPal
 add  hl,bc
 ld   b,8
 call SetBkgPalette
 pop  bc

noB:
 bit  4,b            ; is 'A' pressed?
 jr   z,noA
 push bc
 call nextShape
 pop  bc

noA:
 bit  3,b
 jr   z,noDown
 ld   a,-1
 ld   [sdy],a
noDown:
 bit  2,b
 jr   z,noUp
 ld   a,1
 ld   [sdy],a
noUp:
 bit  1,b
 jr   z,noLeft
 ld   a,2
 ld   [sdx],a
noLeft:
 bit  0,b
 jr   z,keysEnd
 ld   a,-2
 ld   [sdx],a
keysEnd:
 ret

nextShape:
 ld   a,[Shape]
 inc  a
 cp   ShapeMax+1
 jr   nz,@+3
ShapeIni:
 xor  a
 ld   [Shape],a
 ld   b,0
 ld   de,ShapeList
 add  a,a               ; no more 128 shapes in list
 ld   l,a
 ld   h,b
 add  hl,de             ; hl=adress in ShapeList

 ld   a,[hli]
 ld   h,[hl]
 ld   l,a               ; hl=adress of current shape

 ld   c,[hl]            ; bc=(length of atributes place)+1 (this length)
 add  hl,bc             ; hl=start points of shape

 ld   a,[hli]          
 ld   [nPoints],a
 ld   e,a
 ld   c,a               ; remove, here for obj info
 push bc                ; and pop bc in down
 ld   a,[hli]
 inc  a                 ;
 ld   [nTriangles],a    ; +1,coz in verify end, first decrement
 dec  a
 ld   c,a               ; remove, here for obj info
 push bc                ; and pop bc in down
 ld   a,[hli]
 ld   [nSurfaces],a

 ld   a,e               ; nPoints
 add  a,a
 add  a,a               ;
 add  a,e               ; *5
 ld   b,a               ;

 ld   de,CurrentPoints
MoveCurrentPnts:
 ld   a,[hli]
 ld   [de],a            ;
 inc  e
 dec  b
 jr   nz,MoveCurrentPnts
;hl=start lines of shape, on CurrentPoints they are

 ld   a,c               ; nTriangles
 add  a,a               ;
 add  a,a               ;
 add  a,c               ; *5
 ld   b,a

 ld   de,CurrentTriangl
MoveCurrentLines:
 ld   a,[hli]
 ld   [de],a            ; 
 inc  e
 dec  b
 jr   nz,MoveCurrentLines
;hl=start surfaces of shape, on CurrentLines they are

 ld   a,l
 ld   [Surfaces],a
 ld   a,h
 ld   [Surfaces+1],a
 pop  hl                ; hl=HowManyLines
 pop  hl                ; hl=HowManyPoints
noSelect:
noGetKeys:
 ret

;------------------------------------------------------
Rotator:
 ld   a,[nPoints]       ;
 ld   [nPointsTmp],a    ;
 ld   a,[nTriangles]    ; ini all counters
 ld   [nTrianglesTmp],a ;
 ld   a,[nSurfaces]     ;
 ld   [nSurfacesTmp],a  ;

; STEP 1: definition visible surfaces
 ld   de,VisibleSurfaces
CheckVisible:
 push de
 push hl                ; ListSurFaces of this Shape
 call MatrixVectorHLMulti     ; rotate NORMAL
 pop  hl
 pop  de
 ld   a,[nvp+2]         ; Nz'
 and  $80
 ld   [de],a            ; 0 - invisible; $80 (NZ)-visible
 inc  e
 ld   bc,3
 add  hl,bc
 ld   a,[nSurfacesTmp]  ; decrement Surfaces counter
 dec  a                 ;
 ld   [nSurfacesTmp],a
 jr   nz,CheckVisible
; END of STEP 1

;--------------------------------------------
RotatePnts:             ; REMAKE VERIFYING!!!!!!!!!!!!!!!!!!!!

; STEP 2: rotation points, which on at least on one visible surface
 ld   hl,CurrentPoints
 ld   b,$0f             ; d still VisibleSurfaces hi-byte
RotateVPoints:
 ld   a,[hli]           ; sf12
 ld   c,a
 and  b
 ld   e,a
 ld   a,[de]            
 or   a                 ; is this (1) surface visible?
 jr   nz,VisiblePnt0    ; yes
 ld   a,c
 swap a
 and  b
 ld   e,a
 ld   a,[de]            
 or   a                 ; is this (2) surface visible?
 jr   nz,VisiblePnt0    ; yes
 ld   a,[hli]           ; sf34
 ld   c,a
 and  b
 ld   e,a
 ld   a,[de]            
 or   a                 ; is this (3) surface visible?
 jr   nz,VisiblePnt1    ; yes
 ld   a,c
 swap a
 and  b
 ld   e,a
 ld   a,[de]            
 or   a                 ; is this (4) surface visible?
 jr   nz,VisiblePnt1    ; yes
 inc  l
 inc  l                 ; pass x,y,z
 inc  l                 ;
 jr   EndPointVerify
VisiblePnt0:
 inc  l
VisiblePnt1:
 push hl                ; hl=x,y,z of CurrentPnt
 call MatrixVectorHLMulti
 pop  hl
 inc  h                 ; in RotatedPnt Array now
 ld   a,[nvp]
 add  a,16
 ld   [hli],a           ; x'
 ld   a,[nvp+1]
 add  a,16
 ld   [hli],a           ; y'
 inc  l                 ; here z',pass it
 dec  h                 ; again in Current Points
 ld   d,VisibleSurfaces/256
 ld   b,$0f
EndPointVerify:
 ld   a,[nPointsTmp]    ; decrement Points counter
 dec  a                 ;
 ld   [nPointsTmp],a
 jr   nz,RotateVPoints
; END of STEP 2

;--------------------------------------------
; STEP 3: DrawTriangles (if it on VisibleSurface)
 jp   DrawTriangles
MoiCweta:
 RGBSet   $1c,3,6
 RGBSet   $1c,$1e,7
 RGBSet   0,$18,2
 RGBSet   $0e,$17,$1a
 RGBSet   8,2,$18
 RGBSet   $1f,$1d,$1b