/***********************************************************************************

  Module :	Power.c

  Description :	

  Last Modified $Date: $

  $Revision: $

  Copyright (C) 29 May 2005 T Swann

***********************************************************************************/

//**********************************************************************************
//   Include Files
//**********************************************************************************
#include "Power.h"

//**********************************************************************************
//   Local Macros
//**********************************************************************************

//**********************************************************************************
//   Local Constants
//**********************************************************************************

//**********************************************************************************
//   Static Prototypes
//**********************************************************************************
int		sceKernelCreateThread( const char * name, void * func, int initPriority, int stacksize, void * arg, int option );
int		sceKernelStartThread( int thid, int arg0, int arg1 );
int		sceKernelRegisterExitCallback( int cbid );
int		sceKernelCreateCallback( const char * name, void * func );
void	sceKernelPollCallbacks();
void	sceKernelExitGame();

//**********************************************************************************
//   Global Variables
//**********************************************************************************

//**********************************************************************************
//   Static Variables
//**********************************************************************************

//**********************************************************************************
//   Class Definition
//**********************************************************************************

//*************************************************************************************
//	
//*************************************************************************************
int		ExitCallback()
{
	sceKernelExitGame();

	return 0;
}

//*************************************************************************************
//	Thread to create the callbacks and then begin polling 
//*************************************************************************************
int		CallbackThread( void * arg )
{
	int	cbid = sceKernelCreateCallback( "Exit Callback", ExitCallback );
	sceKernelRegisterExitCallback( cbid );
	sceKernelPollCallbacks();

	return 0;
}

//*************************************************************************************
//	Sets up the callback thread and returns its thread id
//*************************************************************************************
int		SetupPowerCallbacks()
{
	int thid = sceKernelCreateThread( "update_thread", CallbackThread, 0x11, 0xFA0, 0, 0 );

	if ( thid >= 0 )
	{
		sceKernelStartThread( thid, 0, 0 );
	}

	return thid;
}

//*******************************  END OF FILE  ************************************
